/*
// heartland animatie sequenties
//
// animaties voor animatie lengte 16
//
//      00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15
//  M -1  78 79 7a 7b 7b 7a 79 78 78 79 7a 7b 7b 7a 79 78
//  F -2  70 71 72 71 70 77 76 77 70 71 72 71 70 77 76 77
//  S -3  1e 26 27 28 29 2a 2b 2c 3b 2c 2b 2a 29 28 27 26
//
*/

#include <stdio.h>
#include <stdlib.h>
#include "hland.h"

/* -1 */
byte munt_ani[]=
{
  0x78,
  0x79,
  0x7a,
  0x7b,
  0x7b,
  0x7a,
  0x79,
  0x78,
  0x78,
  0x79,
  0x7a,
  0x7b,
  0x7b,
  0x7a,
  0x79,
  0x78,
};

/* -2 */
char fles_ani[]=
{
  0x70,
  0x71,
  0x72,
  0x71,
  0x70,
  0x77,
  0x76,
  0x77,
  0x70,
  0x71,
  0x72,
  0x71,
  0x70,
  0x77,
  0x76,
  0x77,
};

/* -3 */
char punt_ani[]=
{
  0x1e,
  0x26,
  0x27,
  0x28,
  0x29,
  0x2a,
  0x2b,
  0x2c,
  0x3b,
  0x2c,
  0x2b,
  0x2a,
  0x29,
  0x28,
  0x27,
  0x26,
};

byte buffer[500000UL];

void doit(FILE* outf, byte *p)
{
  long i;
  int w=100;
  for(i=0; i<ANIMATED_OBJECTS; i++)
  {
    if(w>=16)
    {
      fprintf(outf,"\ndc.b ");
      w=0;
    }
    fprintf(outf, "%i,", p[i]);
    w++;
  }
  fprintf(outf, "\n");
}

void make_it(byte* buf, byte* obj)
{
  int i;
  for(i=0; i<ANI_LEN; i++)
  {
    buf[i*ANIMATED_OBJECTS]=obj[i];
  }
}

int main(void)
{
  FILE*f;
  if((f=fopen("ani_data.s","w"))==NULL)
  {
    printf("ani data file open error!\n");
    return -1;
  }
  fprintf(f,";\n"
            "; file generated by: " __FILE__ "\n"
            ";\n\nEXPORT ani_base\n\nDATA\n"
         );
  make_it(buffer+ANIMATED_OBJECTS-1, munt_ani);
  make_it(buffer+ANIMATED_OBJECTS-2, fles_ani);
  make_it(buffer+ANIMATED_OBJECTS-3, punt_ani);
  doit(f, buffer);
  fprintf(f,"ani_base:\n");
  {
    int i;
    for(i=1; i<ANI_LEN; i++)
    {
      doit(f, buffer+i*ANIMATED_OBJECTS);
    }
  }
  fclose(f);
  return 0;
}
